local TABAS_Sprites = require("TABAS_Sprites")
-- local TABAS_Compat = require("TABAS_Compat")

local function SetProperty(props, property, val)
    if props:Is(property) then
        if props:Val(property) ~= val then
            props:Set(property, val, true)
        end
    else
        props:Set(property, val)
    end
end

local function UnSetProperty(props, property)
    if props:Is(property) then
        props:UnSet(property)
    end
end

local function SetAttachedWall(props)
    local facing = props:Val("Facing")
    if facing == "S" then
        SetProperty(props, "attachedN", "")
    elseif facing == "E" then
        SetProperty(props, "attachedW", "")
    elseif facing == "W" then
        SetProperty(props, "attachedE", "")
    else -- facing == "North" then
        SetProperty(props, "attachedS", "")
    end
end

-- 
local function createDeluxeShowerNWProps(spriteManager)
    local baseProps = spriteManager:getSprite("fixtures_bathroom_01_32"):getProperties()
    for dir, spriteName in pairs(TABAS_Sprites.Shower["Deluxe"]) do
        if dir == "spriteN" or dir == "spriteW" then
            local props = spriteManager:getSprite(spriteName):getProperties()
            props:CreateKeySet()
            props:AddProperties(baseProps)
            local facing = string.gsub(dir, "sprite", "")
            SetProperty(props, "Facing", facing)
        end
    end
end

local function setSpriteOffset(dir, props)
    -- local index = {"32", "33", "70", "71"}
    local offsets = {}
    if dir == "spriteS" then
        offsets = {"0","1","38","39"}
    elseif dir == "spriteE" then
        offsets = {"-1","0","37","38"}
    elseif dir == "spriteN" then
        offsets = {"-38","-37","0","1"}
    elseif dir == "spriteW" then
        offsets = {"-39","-38","-1","0"}
    end
    SetProperty(props, "Soffset", offsets[1])
    SetProperty(props, "Eoffset", offsets[2])
    SetProperty(props, "Noffset", offsets[3])
    SetProperty(props, "Woffset", offsets[4])
end

local function TABAS_OnGameStart()
--- Bath Tub Properties ---
    local spriteManager = IsoSpriteManager.instance
    local props
    local remainTubWater = SandboxVars.TakeABathAndShower.RemainTubFaucetWater
    local remainShowerWater = SandboxVars.TakeABathAndShower.RemainShowerFaucetWater
    for name, value in pairs(TABAS_Sprites.Bathtub) do
        for dir, bath in pairs(value) do
            props = spriteManager:getSprite(bath.faucet):getProperties()
            if props then
                if name == "Large Deluxe" then
                    SetProperty(props, "ItemHeight", "20")
                end
                SetProperty(props, "IsLow", "")
                SetProperty(props, "waterPiped", "")
                SetProperty(props, "waterMaxAmount", tostring(remainTubWater))
                SetProperty(props, "waterAmount", tostring(remainTubWater))
            else
                print("TABAS_OnGameStart: Fetch Bath Sprites Failed!")
            end
            props = spriteManager:getSprite(bath.tub):getProperties()
            if props then
                if name == "Large Deluxe" then
                    SetProperty(props, "ItemHeight", "20")
                end
                SetProperty(props, "IsLow", "")
                UnSetProperty(props, "waterAmount")
                UnSetProperty(props, "waterMaxAmount")
                UnSetProperty(props, "waterPiped")
                UnSetProperty(props, IsoFlagType.waterPiped)
            else
                print("TABAS_OnGameStart: Fetch Bath Sprites Failed!")
            end
        end
    end

    --- Shower Properties ---
    createDeluxeShowerNWProps(spriteManager) -- for deluxe shower N and W
    for name, value in pairs(TABAS_Sprites.Shower) do
        for dir, shower in pairs(value) do
            props = spriteManager:getSprite(shower):getProperties()
            if props then
                if name == "Deluxe" then
                    setSpriteOffset(dir, props) -- for deluxe shower N and W
                    SetProperty(props, "ItemHeight", "7")
                end
                SetProperty(props, "PickUpTool", "Wrench") -- not hummer
                SetProperty(props, "PlaceTool", "Wrench") -- not hummer
                UnSetProperty(props, "PickUpLevel")
                SetProperty(props, "waterPiped", "")
                SetProperty(props, "waterMaxAmount", tostring(remainShowerWater))
                SetProperty(props, "waterAmount", tostring(remainShowerWater))
                SetAttachedWall(props)
            else
                print("TABAS_OnGameStart: Fetch Shower Sprites Failed!")
            end
        end
    end
end

Events.OnGameStart.Add(TABAS_OnGameStart)

